/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于日志接口
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2019.10.30
 *      内容 : 所有代码
 *************************************************************************************************/

/*exported mc_ui_logger*/

/************************************************************************************************
 * 类型:
 *    log对象
 * 功能:
 *    分类型记录log
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 例子：
 *    NA
 * 备注：
 *    五种日志类型 DEBUG|INFOR| WARN|ERROR|FATAL
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2019.10.30
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_ui_logger() {
    //最大条数
    var m_cui_max_log_cnt = 100000;
    var m_ary_log_dat = new Array(m_cui_max_log_cnt);
    //日志下标
    var m_ui_index = 0;

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    时间格式转换函数
     * 参数:
     *    @param { Promise<String> } b_has_sec 是否显示秒数; 默认不显示
     * 返回：
     *    @return { Promise<String> } 返回转换后的时间格式
     * 例子：
     *    NA
     * 备注：
     *    时间格式：[yyyy-mm-dd hh-mm-ss.xxx]
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    var get_sys_time = function (b_has_sec) {
        var time = new Date();

        var time_year = time.getFullYear();
        var time_month = time.getMonth() + 1;
        var time_date = time.getDate();

        var time_hours = time.getHours();
        var time_minutes = time.getMinutes();
        var time_seconds = time.getSeconds();
        var time_milliseconds = time.getMilliseconds();

        if (b_has_sec) {
            if (100 > time_milliseconds) {
                time_milliseconds = "0" + time_milliseconds;
            } else if (10 > time_milliseconds) {
                time_milliseconds = "00" + time_milliseconds;
            }
        }

        var format_time = function (time_) {
            if (10 > time_) {
                time_ = "0" + time_;
            }
            return time_;
        };

        var time_value =
            "[" +
            time_year +
            "-" +
            format_time(time_month) +
            "-" +
            format_time(time_date) +
            "  " +
            format_time(time_hours) +
            "-" +
            format_time(time_minutes) +
            "-" +
            format_time(time_seconds) +
            (b_has_sec ? "." + time_milliseconds : "") +
            "]";

        return time_value;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    封装所有日志类型并返回转换之后的格式
     * 参数:
     *    @param { Promise<string> } msg 日志的内容
     *    @param { Promise<string> } log_type_name 日志的类型名称
     * 返回：
     *    @returns { Promise<Boolean> } true 设置成功  | false 参数类型错误或为空时
     * 例子：
     *    NA
     * 备注：
     *    返回的日志格式：[yyyy-mm-dd hh-mm-ss.xxx]  DEBUG|INFOR| WARN|ERROR|FATAL  :  msg
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    var push_log = function (msg, log_type_name) {
        if ("string" !== typeof msg || 0 === msg.length) {
            return false;
        }

        var time_format = get_sys_time();
        var str_result_msg;

        if ("WARN" === log_type_name) {
            str_result_msg = time_format + "   " + log_type_name + "  :  " + msg;
        } else {
            str_result_msg = time_format + "  " + log_type_name + "  :  " + msg;
        }

        m_ary_log_dat[m_ui_index] = str_result_msg;
        m_ui_index += 1;

        if (m_ui_index >= m_cui_max_log_cnt) {
            m_ui_index = 0;
        }

        return true;
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    插入dubug类型的日志
     * 参数:
     *    @param { Promise<string> } str_msg 日志的值(debug类型)
     * 返回：
     *    @return { Promise<Boolean> } 插入日志之后封装格式的函数
     * 例子：
     *    NA
     * 备注：
     *    五种数据类型
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.debug = function (str_msg) {
        return push_log(str_msg, "DEBUG");
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    插入infor类型的日志
     * 参数:
     *    @param { Promise<string> } str_msg 日志的值(infor类型)
     * 返回：
     *    NA
     * 例子：
     *    @return { Promise<Boolean> }
     * 备注：
     *    五种数据类型
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.infor = function (str_msg) {
        return push_log(str_msg, "INFOR");
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    插入warn类型的日志
     * 参数:
     *    @param { Promise<String> } str_msg 日志的值(warn类型)
     * 返回：
     *    @return { Promise<Boolean> }
     * 例子：
     *    NA
     * 备注：
     *    五种数据类型
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.warn = function (str_msg) {
        return push_log(str_msg, "WARN");
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    插入error类型的日志
     * 参数:
     *    @param { Promise<String> } str_msg 日志的值(error类型)
     * 返回：
     *    @return { Promise<Boolean> }
     * 例子：
     *    NA
     * 备注：
     *    五种数据类型
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.error = function (str_msg) {
        var b_log_error = push_log(str_msg, "ERROR");

        if (b_log_error) {
            if (0 === m_ui_index) {
                console.log(m_ary_log_dat[m_cui_max_log_cnt - 1]); // eslint-disable-line
            } else {
                console.log(m_ary_log_dat[m_ui_index - 1]); // eslint-disable-line
            }
        }

        return b_log_error;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    插入fatal类型的日志
     * 参数:
     *    @param { Promise<String> } str_msg 日志的值(fatal类型)
     * 返回：
     *    @return { Promise<Boolean> }
     * 例子：
     *    NA
     * 备注：
     *    五种数据类型
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.fatal = function (str_msg) {
        return push_log(str_msg, "FATAL");
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    清空日志
     * 参数:
     *    NA
     * 返回：
     *    NA
     * 例子：
     *    NA
     * 备注：
     *    清空之后下标设置为0
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.reset = function () {
        m_ary_log_dat = [];
        m_ary_log_dat.length = m_cui_max_log_cnt;
        m_ui_index = 0;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取所有日志
     * 参数:
     *    NA
     * 返回：
     *    @return { Promise<Array> } 存放日志的数组
     * 例子：
     *    NA
     * 备注：
     *    返回的数组需要重新排序
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.10.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_log_txt = function () {
        var m_ary_log_dat_sort;

        if (m_ary_log_dat[m_cui_max_log_cnt - 1]) {
            m_ary_log_dat_sort = m_ary_log_dat.slice(m_ui_index).concat(m_ary_log_dat.slice(0, m_ui_index));
        } else {
            m_ary_log_dat_sort = m_ary_log_dat;
        }
        return m_ary_log_dat_sort;
    };

    // 获取系统时间
    // @param { Promise<String> } b_has_sec 是否显示秒数; 默认不显示
    this.get_system_time = function (b_has_sec) {
        return get_sys_time(b_has_sec);
    };
}
